<?php
/*
	Stempora web framework
	copyright (c) 2002-2016 Stempora
		web:  www.stempora.com
		mail: support@stempora.com

*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CPlugin{
	
	var $tplvars; 

	function __construct() {		
	}

	function __load() {

		//load the config file
		$this->_xmlFile = _MODPATH . $this->name . "/module.xml";
		$this->_xmlPath = _MODPATH . $this->name;
		$this->_aclFile = _MODPATH . $this->name . "/acl.xml";


		if (file_exists($this->_xmlFile)) {
			$conf = new CConfig($this->_xmlFile);
			$this->conf = $conf->vars["module"];


			//load the templates and the tables
			if (is_array($this->conf["tables"])) {
				foreach ($this->conf["tables"] as $key => $val) {
					$this->private->tables[$key] = $val;
				}
			}
		}

		if (file_exists($this->_aclFile)) {
			$conf = new CConfig($this->_aclFile);
			$this->acl = $conf->vars["perms"];
		}


		global $site;

		if (!$site->admin) {

			$rules = $this->_xmlPath . "/rewrite.txt";
			if (file_exists($rules)) {
				$rules_list = file($rules);

				if (is_array($rules_list) && count($rules_list)) {
					foreach ($rules_list as $key => $val) {

						$site->rewriteRules[] = str_replace("\t" , " " , trim($val));
					}
					
				}
				
			}
			
		}
		

/*
			//load the templates
			if (is_array($this->conf["templates"])) {
				foreach ($this->conf["tables"] as $key => $val) {
					$this->private->templates[$key] = new CTemplateDyn($val);
				}
				
			}
			
		}
*/					
	}	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function __preinit() {

	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function doEvents() {
		
		if (!$this->aclCheck()) {
			return $base->acl->deniedAccess();
		}

		$this->adminDoEvents();
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function adminDoEvents() {
		global $_CONF , $base;


		if ($_GET["mod"] == $this->name) {		
		
			switch ($_GET["sub"]) {

				case "settings.general":
					return $this->adminGeneralSettings();
				break;

				case "settings.advanced":
					return $this->adminAdvancedSettings();
				break;

				case "settings.static-texts":
					return $this->adminStaticTexts();
				break;

			}
		}
		

	}

	function __adminMenu() {
		global $_SESS , $_TSM , $_USER, $base;

		if (!$this->admin) {
			return "";
		}


		//everithing is okay, proceed to themenu building

		if (file_exists( $this->path . "menu.xml") && !(defined("STP_DISABLE_MODULE_" . strtoupper($this->name) ) && constant("STP_DISABLE_MODULE_" . strtoupper($this->name)) )) {


			//check the permission agains this module

			//if (is_object($this->plugins["administrators"]) && $this->plugins["administrators"]->CheckGlobalPermission($this->name)) {

				$tmp_menu = new CConfig($this->path . "menu.xml");

				if (is_array($tmp_menu->vars["menu"])){
					foreach ($tmp_menu->vars["menu"] as $key => $val) {

						if (!$val["acl"] || ($val["acl"] && $base->acl->checkRule($val["acl"]))) {

							if (is_array($val["link"])) {
								$links = array();

								foreach ($val["link"] as $k => $v) {

									if (!$v["acl"] || ($v["acl"] && $base->acl->checkRule($v["acl"]))) {

										$selected  = "";

										if ($v["selected"] && stristr($v["selected"] , "eval:")) {
											eval("\$selected = " . str_replace("eval:" , "" , $v["selected"] ));
											//debug($val);
										}

										$v["selected"] = $selected;

										$links[] = $v;
									}
								}


							} else {

								$links = $val["link"];
							}

							$k = $val["id"] ? $val["id"] : ucwords($key);

							if ($val["restricted"] && CForm::__isRestricted($val["restricted"])) {
							} else {				

								$selected  = "";

								if ($val["selected"] && stristr($val["selected"] , "eval:")) {
									eval("\$selected = " . str_replace("eval:" , "" , $val["selected"] ));

									//debug($val);
								}
								

								$this->private->menu[$k] = array(
									"id"	=> $val["id"] ? $val["id"] : "",
									"icon"	=> $val["icon"],
									"prio"	=> $val["prio"] ? $val["prio"] : "999",
									"title"	=> ucwords($key),
									"link"	=> $links , 
									"pos"	=> $val["pos"],
									"level"	=> $val["level"],
									"parent"=> $val["parent"],
									"subtitle"=> $val["subtitle"],
									"selected"	=> $selected,
								);
							}											
						}						
						
					}

				}
			//}
			

			
						
		}

	
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function PrepareFields(&$forms) {

		global $_TSM , $_MODULES , $base;

		if ($this->tpl_module["mod_name"] && ($this->tpl_module["mod_module_code"] != "category")) {
			$_TSM["PUB:MODULE_NAME"] = $this->tpl_module["mod_name"];			
			$_TSM["PUB:MODULE_LINK"] = $_MODULES["modules"]->PrepareLink($this->tpl_module);
			
			if ($this->tpl_module["mod_parent"]) {
				$parent = $this->plugins["modules"]->GetModuleInfo($this->tpl_module["mod_parent"],false);
				$_TSM["PUB:MODULE_NAME_PARENT"] = array(
					"title"	=> $parent["mod_name"],
					"link"	=> $base->acl->checkRule("module:cats.edit") ? "index.php?mod=modules&sub=cats&mod_id={$parent[mod_id]}&action=details" : "",
				);
			}
			
		} else {
			$_TSM["PUB:MODULE_NAME"] = $this->tpl_module["module_name"] ? $this->tpl_module["module_name"] : $this->tpl_module["module_type_name"];
			$_TSM["PUB:MODULE_LINK"] = $_MODULES["modules"]->PrepareLink($this->tpl_module);

		}
		


		if (is_array($forms["list"])&& !is_array($forms["list"]["title"])) {
			$forms["list"]["title"] = CTemplateStatic::Replace(
				$forms["list"]["title"],
				array( "title" => $this->tpl_module["mod_name"])
			);
		}
		

		if (is_array($forms["edit"]) && !is_array($forms["edit"]["title"])) {
			$forms["edit"]["title"] = CTemplateStatic::Replace(
				$forms["edit"]["title"],
				array( "title" => $this->tpl_module["mod_name"])
			);
		}
		

		if (is_Array($forms["add"]) && !is_array($forms["add"]["title"])) {
			$forms["add"]["title"] = CTemplateStatic::Replace(
				$forms["add"]["title"],
				array( "title" => $this->tpl_module["mod_name"])
			);
		}
		
		if (is_Array($forms["details"]) && !is_array($forms["details"]["title"])) {
			$forms["details"]["title"] = CTemplateStatic::Replace(
				$forms["details"]["title"],
				array( "title" => $this->tpl_module["mod_name"])
			);
		}

		if (is_Array($forms["search"]) && !is_array($forms["search"]["title"])) {
			$forms["search"]["title"] = CTemplateStatic::Replace(
				$forms["search"]["title"],
				array( "title" => $this->tpl_module["mod_name"])
			);
		}

		//prepare the tabs

		if (file_exists($this->forms_path . "dashboard.xml")) {
			$tabs = new CConfig($this->forms_path . "dashboard.xml" );

			if ($tabs->vars["tabs"]["link"]) {
				$tabs = new CConfig($this->forms_path . $tabs->vars["tabs"]["link"]);
			}

			$this->global_tabs = $this->PrepareTabsAcl($tabs->vars["tabs"]);
		}
		

		if (is_Array($forms["search"])) {	
			$forms["search"]["tabs"] = $this->global_tabs;
		} else {
			$forms["list"]["tabs"] = $this->global_tabs;
		}

		if (is_Array($forms["edit"])) {	
			$forms["edit"]["tabs"] = $this->global_tabs;

//			$this->LangPrepareFields(&$forms["edit"]);
		}

		if (is_Array($forms["add"]) && !is_Array($forms["add"]["tabs"])) {	
			$forms["add"]["tabs"] = $this->global_tabs;
		}
		
		if (is_Array($forms["details"])) {	
			$forms["details"]["tabs"] = $this->global_tabs;
//			$this->LangPrepareFields(&$forms["details"]);

		}

		if (is_Array($forms["add"])) {	
//			$this->LangPrepareFields(&$forms["add"]);

		}

		
		if ($this->name !="languages") {
			if (!$_REQUEST["lang_id"]) {
				$lang = $this->db->QFetchArray("SELECT * FROM {$this->tables['core:languages']} WHERE lang_default=1");
				$_GET["lang_id"] = $lang["lang_id"];
			}
		}	
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function PrepareTabsAcl($tabs , $module = null) {
		global $base;



		$module = $module != null ? $module : $this->tpl_module;


		if (is_array($tabs)) {
			foreach ($tabs as $key => $val) {

				if (is_array($val["link"]) && $val["link"]["link"]) {
					$tabs[$key]["link"] = array($val["link"]);
				}
			}

			foreach ($tabs as $key => $val) {

				if (is_array($val["link"])) {
					foreach ($val["link"] as $k => $v) {
						if ($v["acl"] && !$base->acl->checkModRule($module , $v["acl"])) {
							unset($tabs[$key]["link"][$k]);														
						}						
					}		
					

					//if removed all options, remove the big tab
					if (!count($tabs[$key]["link"])) {
						unset($tabs[$key]);
					}
					
				} elseif ($val["acl"] && !$base->acl->checkModRule($module , $val["acl"])) {
					unset($tabs[$key]);														
				}				
			}
			
		}

		return $tabs;
	}
	
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function PrepareDashboard(&$form) {
		global $_TSM;

		if ($this->tpl_module["mod_name"]) {
			$_TSM["PUB:MODULE_NAME"] = $this->tpl_module["mod_name"];
		} else {
			$_TSM["PUB:MODULE_NAME"] = $this->tpl_module["module_name"] ? $this->tpl_module["module_name"] : $this->tpl_module["module_type_name"];
		}

		if (file_exists($this->forms_path . "dashboard.xml")) {			

			$tabs = new CConfig($this->forms_path . "dashboard.xml");

			if ($tabs->vars["tabs"]["link"]) {
				$tabs = new CConfig($this->forms_path . $tabs->vars["tabs"]["link"]);
			}

			$this->global_tabs = $this->prepareTabsAcl($tabs->vars["tabs"]);

			$form["tabs"] = $this->global_tabs;

		}

		//check for multilanguage
	}

	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DashboardWidgets($mod_id = null) {
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DashboardNumbers($mod_id = null) {
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DashboardButtons($mod_id = null) {
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function adminGetWidgets($module) {
		return $this->adminGetWidgetsList($module);
	}

	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Widget($widget) {
	
		//load widgets list
		$this->loadWidgets();
		
		//initialize widget
		$this->initWidget($widget["widget_type"]);

		if (is_object($this->widgets[$widget["widget_type"]])) {			
			//render widget
			return $this->widgets[$widget["widget_type"]]->Render($widget);
		}

	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function UserMenuAppend($module){
		global $_SESS;

		if ($module["deny"]) {
			return "";
		}
		

		if ($module["mod_protected"] && is_array($_SESS["client"])) {

			if ($module["module_code"] != "category") {

				switch ($module["module_type"]) {
					case "1":
						return array(
							array(
								"title"	=> $module["mod_name"], 
								"link"	=> $module["link"],
								//"priority"	=> 10,
								"current"	=> $module["mod_id"] == $_GET["module_id"] ? "true" : "",
							),

						);
					break;

					case "2":
						return array(
							array(
								"title"	=> $module["module_name"], 
								"link"	=> $module["link"],
								//"priority"	=> 10,
								"current"	=> $this->name == $_GET["mod"] ? "true" : "",

							),

						);
					break;
				}
			}			
		}
	}

	

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function __install($module) {
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function __uninstall($module) {
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function __adminTexts($sub = "texts") {

			if (!$_GET["action"]) {
				$_GET["action"] = "details";
			}


			if (!$this->tpl_module["mod_id"] && $this->tpl_module["module_id"]) {
				$_GET["module_id"] = $this->tpl_module["module_id"];
			}
			

			//check id
			
			$data = new CSQLAdmin($sub , $this->__parent_templates,$this->db,$this->tables,$extra);

			$this->PrepareFields($data->forms["forms"]);
			$this->PrepareTextFields($data->forms["forms"]);

			$this->__adminTextsCheckTextRecord($data->forms);

			$data->functions = array( 
//					"onstore_prepare" => array(&$this , "__StoreAdminTexts"),
			);					

			return $data->DoEvents();
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function PrepareTextFields(&$forms) {

		$_fields = new CConfig($this->plugins["core"]->forms_path . "module-head-seo-fields.xml");


		$fields = array(
			"snipets"	=> array(
				"sem_title" , "seo_conv_head" , "seo_conv_body" , 
			),
			"width"	=> array(
				"subtitle_sizes" , "text_title_align" , "text_subtitle_align" , "text_title_valign" , "text_subtitle_valign" , 
				"text_title_size", "text_title_size_lg", "text_title_size_md" , "text_title_size_sm" , "text_title_size_xs",
				"text_subtitle_size" , "text_subtitle_size_lg" , "text_subtitle_size_md" , "text_subtitle_size_sm" , "text_subtitle_size_xs",
			),
			"css" => array(
				"subtitle_advanced"	, "animation" , 
				"text_pt_css" , "text_pt_css_title" , "text_pt_css_subtitle"
			),

			"subtitle"	=> array(
				"text_subtitle",
				"text_subtitle_align" , "text_subtitle_valign" ,
				"text_subtitle_size" , "text_subtitle_size_lg" , "text_subtitle_size_md" , "text_subtitle_size_sm" , "text_subtitle_size_xs",
				"text_pt_css_subtitle",
			),

			"align"	=> array(
				"text_title_align" , "text_title_valign" ,
				"text_subtitle_align" , "text_subtitle_valign" ,
			)
		);

		$forms["details"]["fields"]["box"][1] = $_fields->vars["fields"]["box"];
		$forms["edit"]["fields"]["box"][1] = $_fields->vars["fields"]["box"];


		if (STP_PAGEHEADER_NO_SNIPET) {
			CForm::DeleteFields($forms["edit"] , $fields["snipets"]);
			CForm::DeleteFields($forms["details"] , $fields["snipets"]);
		}
		if (STP_PAGEHEADER_NO_WIDTHS) {
			CForm::DeleteFields($forms["edit"] , $fields["width"]);
			CForm::DeleteFields($forms["details"] , $fields["width"]);
		}

		if (STP_PAGEHEADER_NO_CSS) {
			CForm::DeleteFields($forms["edit"] , $fields["css"]);
			CForm::DeleteFields($forms["details"] , $fields["css"]);
		}

		if (STP_PAGEHEADER_NO_SUBTITLE) {
			CForm::DeleteFields($forms["edit"] , $fields["subtitle"]);
			CForm::DeleteFields($forms["details"] , $fields["subtitle"]);
		}

		if (STP_PAGEHEADER_NO_ALIGN) {
			CForm::DeleteFields($forms["edit"] , $fields["align"]);
			CForm::DeleteFields($forms["details"] , $fields["align"]);
		}

		//check for cases when i need to extend the first box to 12 columns

		if (is_Array($forms["edit"]["fields"]["box"]) && !count($forms["edit"]["fields"]["box"][1]["fields"]) && ($forms["edit"]["fields"]["box"][0]["width"] != 12)) {
			unset($forms["details"]["fields"]["box"][1]);
			unset($forms["edit"]["fields"]["box"][1]);

			$forms["details"]["fields"]["box"][0]["width"] =
			$forms["edit"]["fields"]["box"][0]["width"] = 12;
		}
		
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function getTexts($tables = array() , $sub_id = "") {

		if (!count($tables)) {
			$tables = array(
				"core"	=> $this->tables["core:texts"],
				"lang"	=> $this->tables["core:texts_lang"],
			);
		}
		

		if ($this->tpl_module["mod_id"]) {
			$text = $this->db->QFetchArray(
				"SELECT * FROM 
					{$tables['core']} as r , 
					{$tables['lang']} as l
				WHERE
					r.module_id = l.module_id AND 
					l.lang_id = {$this->tpl_module[lang_id]} AND
					r.module_id={$this->tpl_module[mod_id]} 
				" . ($sub_id ? " AND r.sub_id = l.sub_id AND l.sub_id LIKE '{$sub_id}' " : "")
			);

			return $text;
		} else {
			$text = $this->db->QFetchArray(
				"SELECT * FROM 
					{$tables['core']} as r , 
					{$tables['lang']} as l
				WHERE
					r.module_id = l.module_id AND 
					l.lang_id = {$this->tpl_module[lang_id]} AND
					r.module_id={$this->tpl_module[module_id]}
				" . ($sub_id ? " AND r.sub_id = l.sub_id AND l.sub_id LIKE '{$sub_id}' " : "")
			);

			return $text;
		}
		
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function __StoreAdminTexts($record) {


	}
	


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function __adminTextsCheckTextRecord(&$forms) {

		if (!$_GET["module_id"]) {
			return "";
		}
		

		if (!is_array($this->db->QFetchArray("SELECT * FROM " . $this->tables[$forms["table"]] . " WHERE module_id={$_GET[module_id]}" . ($_GET["sub_id"] ? " AND sub_id LIKE '{$_GET[sub_id]}' " : "" ))  )) {
			$this->db->QueryInsert(
				$this->tables[$forms["table"]],
				array(
					"module_id"	=> $_GET["module_id"],
					"sub_id"	=> $_GET["sub_id"],
				)
			);
		}		

	}

	
	function LangPrepareFields(&$form) {
		global $base;

	
		if (!$_REQUEST["lang_id"]) {
			$lang = $this->db->QFetchRowArray("SELECT * FROM {$this->tables['core:languages']} WHERE lang_default=1");
			$_GET["lang_id"] = $lang["lang_id"];
		}
		
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetMenuButton($record , $options = array()) { 
		global $_SESS , $_CONF;

		if (is_array($record)) {


			//to be fixed
			if (
					$record["mod_invisible"] || (($record["mod_protected"] == "1") && !$record["mod_protected_show"] && !is_array($_SESS["client"]))

			) {

			} else {			

				switch ($record["module_type"]) {
					//instance
					case "1":
						return array(
							"mod_id"	=> $record["mod_id"],
							"title"		=> $record["mod_name"],
							"link"		=> $record["home"] ? ($record["home_link"] ? $record["home_link"] : $_CONF["url"])  : $record["link"],
							"subtitle"	=> $record["mod_subtitle"],
							"selected"	=> $record["mod_id"] == $_GET["module_id"]  ? true : false,
							"image"		=> $record["mod_image"] ? "upload/modules/" . $record["mod_id"] . ".png" : "",
							"target"	=> "",
							"rel"		=> "",

							"html"		=> $options["html"],
							"sub"		=> $options["sub"],

							"pos"		=> $record["mod_pos"]

						);
					break;

					//system
					case "2":
						return array(
							"mod_id"	=> "m-" . $record["module_id"],
							"title"		=> $record["module_name"],
							"link"		=> $record["link"],
							"subtitle"	=> $record["module_subtitle"],
							"selected"	=> $record["module_id"] == $_GET["module_id"]  ? true : false,
							"image"		=> $record["module_image"] ? "upload/modules/" . $record["module_id"] . ".png" : "",
							"target"	=> "",
							"rel"		=> "",

							"html"		=> $options["html"],
							"sub"		=> $options["sub"],

						);
					break;
				}
								
			}
		}

		
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onDelete($module_data) {
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onCreate($module_data) {

		//load any existing settings
		if (file_exists($this->path . "install/settings.xml")) {
			$settings = new CConfig($this->path . "install/settings.xml");

			$this->plugins["modules"]->UpdateModuleSettings(
				$module_data["mod_id"] , 
				$settings->vars["settings"]
			);
		}


		//load createsql if exists
		if (file_exists($this->path . "install/create.sql")) {
			$db_file = file($this->path . "install/create.sql");

			if (count($db_file)) {
				foreach ($db_file as $key => $val) {

					$val = trim($val);

					if (substr($val, -1) == ";") {

						$last .= $val;

						$this->db->Query(
							CTemplateStatic::Replace(
								$last,
								$this->tables,
								$module_tata
							)
						);

						$last = "";

					} else {
						$last .= $val;
					}
				}
			}
		}

	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function _t($tpl) {
		return $this->private->templates[$tpl];
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function base() {
		global $base;

		return $base;
	}

	
	function _GetItemsPage($table , $limit , $page , $cond , $order , $fields=" * " , $count_fields = "*" , $vars = array()) {
		
		$count	= max(1,$limit);
		$page	= $page ? $page : 1;

	
		if ($cond) {
			$cond = " WHERE {$cond}";
		}
		

		$item_count = $this->db->RowCount(
			"{$table}",
			$cond,
			$count_fields
		);

		if (!$page && $item_count) {
			$page = 1;
		} else 
			$page = max(1,(int)$page);

		$items = $this->db->QFetchRowArray(
			"SELECT {$fields} " . 
			"FROM 
				{$table}
				{$cond}
			ORDER BY  {$order} 
			LIMIT " . ( max(0,($page - 1 ) * $count )) . " , " . $count 
		);

		return array(
			"records"	=> $items, 
			"count"		=> $item_count , 
			"pages"		=> $item_count ? ceil($item_count / $count) : 1,
			"page"		=> $page,

			"ipp"		=> $count
		);

	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function pageTitleBlock($sublinks = array() , $subid = null) {

		if ($subid) {
			$text = $this->getTexts(array() , $subid);
		} else {			
			$text = $this->GetTexts();
		}

		$links = array(
			$this->tpl_module["link"]	=> $this->tpl_module["mod_name"]
		);

		if (count($sublinks)) {
			foreach ( $sublinks as $key => $val) {
				$links[$key] = $val;
			}
		}
			
		$this->module->plugins["breadcrumb"]->Add(
			array(
				"title"		=> $text["text_title"],
				"subtitle"	=> $text["text_subtitle"],
				"show"		=> $text["text_status"],

				"left"		=> $text["text_left"],
				"right"		=> $text["text_right"],

				"raw"		=> $text
			),
			$links,
			$this->tpl_module["mod_id"] ? $this->tpl_module["mod_protected"] : $this->tpl_module["module_protected"],
			$this->tpl_module
		);

		return $text;
		
	}




	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function loadWidgets() {

		if (is_array($this->widgets)) {
			return "";
		}
		
		if (!is_dir($this->path . "widgets")) {
			return "";
		}
		

		$widgets = CDir::GetFiles($this->path . "widgets" , ".php");

		if (is_array($widgets) && count($widgets)) {
			foreach ($widgets as $key => $val) {
				$classname = strtolower("C" . $this->name . str_replace("." , "" , str_replace(".php" , "" , basename($val))));
				$this->widgets[$classname] = basename($val);
			}			
		}
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function initWidget($name) {

		if (is_object($this->widgets[$name])) {
			return true;
		}

		if (!$this->widgets[$name]) {
			return false;
		}
				
		$path = $this->path . "widgets/" . $this->widgets[$name];
		$file = $this->widgets[$name];

		if (!file_exists($path)) {
			return false;
		}
		
		$classname = $name;


		include_once($path);

		$tmp_class = new $classname();

		$tmp_class->xml = $this->path. "widgets/" . str_replace(".php" , ".xml" , $file);
		$tmp_class->tpl = new CTemplateDynamic($this->path. "widgets/" . str_replace(".php" , ".htm" , $file));
		$tmp_class->db = &$this->db;
		$tmp_class->tables = &$this->tables;
		$tmp_class->plugins = &$this->plugins;
		$tmp_class->module = &$this;

		$this->widgets[$name] = $tmp_class;

	}
	
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function adminGetWidgetsList($module) {

		if (!( is_array($this->widgets) && count($this->widgets)) ) {
			$this->loadWidgets();
		}

		if (is_array($this->widgets) && count($this->widgets)) {
			foreach ($this->widgets as $key => $val) {
				$this->initWidget($key);
				$wid[] = $this->widgets[$key]->GetMeta($module);
			}			
		}			

		return $wid;
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function CreatePageTitleBlock($options) {
		global $_LANG_ID;

		$this->db->QueryInsert(
			$this->tables["core:texts"],
			array(
				"module_id"		=> $options["module_id"],
				"text_status"	=> $options["show"],
				"seo_meta"		=> "index,follow",
			)
		);

		$this->db->QueryInsert(
			$this->tables["core:texts_lang"],
			array(
				"module_id"		=> $options["module_id"],
				"lang_id"		=> $_LANG_ID,
				"text_title"	=> $options["title"],
				"text_subtitle"	=> $options["subtitle"],
				"seo_title"		=> $options["title"],
				"seo_meta"		=> "index,follow",
			)
		);
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SetComments($type , $extra = array()) {

		if ($this->plugins["comments"]) {
			$this->plugins["comments"]->connect["type"] = $type;
			$this->plugins["comments"]->connect["extra"]["module"] = $this->tpl_module["mod_id"] ? $this->tpl_module["mod_id"] : $this->tpl_module["module_id"];

			if ($extra["reserved"]) {
				$this->plugins["comments"]->connect["extra"]["reserved"] = $extra["reserved"];
			}

			if (isset($extra["status"])) {
				$this->plugins["comments"]->connect["status"] = $extra["status"];
			}

			if (isset($extra["new"])) {
				$this->plugins["comments"]->connect["new"] = $extra["new"];
			}

			if (isset($extra["link"])) {
				$this->plugins["comments"]->connect["link"] = $extra["link"];
			}
			
		}
		
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function aclCheck() {
		global $base , $site;

		if (!$site->admin) {
			return true;
		}

		
		if ($_GET["mod"] == $this->name) {		


			if (is_array($this->acl) && $this->acl["sections"]) {
				//here i should change the landing based to something else
				if ($this->acl["sections"][$_GET["sub"]] && !$base->acl->checkModRule($this->tpl_module , $this->acl["sections"][$_GET["sub"]])) {

					//problem, i deny the loader of the module, try to find the next option with access
					if ($_GET["sub"] == "landing") {

						//i cycle all the sections i find in acl file 
						foreach ($this->acl["sections"] as $key => $val) {
							if ($key != "landing") {

								// the first i find to be accessible, i force the $_GET to be that one.
								if ($base->acl->checkModRule($this->tpl_module , $val)) {
									$_GET["sub"] = $key;
									return true;
								}								

							}							

						}						
					}



					die("dies in plugins ");

					//need to find a way to show the denied screen
					urlredirect("index.php?mod=denied&sub=landing");
				}
				
			}
		}

		return true;
		
	}
	


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function adminGeneralSettings() {
		if ($this->tpl_module["mod_id"]) {
			urlredirect("index.php?mod=modules&sub=user&action=details&mod_id={$this->tpl_module[mod_id]}&t=u");
		} else {
			urlredirect("index.php?mod=modules&sub=default&action=details&module_code={$this->tpl_module[module_code]}&t=u");
		}
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function adminAdvancedSettings() {

		if ($this->tpl_module["mod_id"]) {
			urlredirect("index.php?mod=modules&sub=user-settings&action=details&mod_id={$this->tpl_module[mod_id]}&t=u");
		} else {
			urlredirect("index.php?mod=modules&sub=default-settings&action=details&module_code={$this->tpl_module[module_code]}&t=u");
		}
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function adminStaticTexts() {
		if ($this->tpl_module["mod_id"]) {
			urlredirect("index.php?mod=modules&sub=user-language&action=details&mod_id={$this->tpl_module[mod_id]}&t=u");
		} else {
			urlredirect("index.php?mod=modules&sub=default-language&action=details&module_code={$this->tpl_module[module_code]}&t=u");
		}
	}
	


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function __init() {
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function __initTemplates($templates = array()) {

		if (count($templates)) {
			foreach ($templates as $key => $val) {
				$this->private->templates[$key] = new CTemplateDynamic(
					$this->tpl_path . $val 
				);
			}
		}
		
	}
	
	
}

?>
